/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.common.util;

import java.util.Objects;
import java.util.function.Supplier;

@FunctionalInterface
public interface NonNullSupplier<T>
extends Supplier<T> {
    public static <T> NonNullSupplier<T> of(Supplier<T> sup) {
        return NonNullSupplier.of(sup, () -> "Unexpected null value from supplier");
    }

    public static <T> NonNullSupplier<T> of(Supplier<T> sup, NonNullSupplier<String> errorMsg) {
        return () -> {
            Object res = sup.get();
            Objects.requireNonNull(res, errorMsg);
            return res;
        };
    }
}

